# /etc/profile.d/zz-bash.sh

export PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:/usr/local/games:/usr/games"

if [ "${BASH-}" ] && [ "$BASH" != "/bin/sh" ]
then
	if [ "$(id -u)" -eq 0 ]
	then
		if [ -n "$SSH_CONNECTION" ]
		then
			PS1="\[\033[1;31m\]\u\[\033[0m\]@\H:\w\\$ "
		else
			PS1="\[\033[1;31m\]\u\[\033[0m\]:\w\\$ "
		fi
	else
		if [ -n "$SSH_CONNECTION" ]
		then
			PS1="\[\033[1;32m\]\u\[\033[0m\]@\H:\w\\$ "
		else
			PS1="\[\033[1;32m\]\u\[\033[0m\]:\w\\$ "
		fi
	fi

	HISTCONTROL="ignoredups:ignorespace"
	HISTFILESIZE="100000"
	HISTSIZE="100000"

	shopt -s cdspell
	shopt -s checkwinsize
	shopt -s histappend
	shopt -s histverify
	shopt -s no_empty_cmd_completion
fi

alias logoff="unset HISTORY; unset HISTFILE; exit"
