# Detrivative Dist Compare

## Installation

TODO

## Usage

Minimal usage:

```
derivative-dist-compare -f ./config-file.yml
```

Manual Page:

```
usage: derivative-dist-compare [-h] [-d] [-l LOG_FILE] -f CONFIG_FILE [-j JSON_OUTPUT] [-o HTML_OUTPUT]

Debian package tracker for derivative distributions

options:
  -h, --help            show this help message and exit
  -d, --debug           Enable debug mode
  -l LOG_FILE, --log-file LOG_FILE
                        Log file location
  -f CONFIG_FILE, --config-file CONFIG_FILE
                        Config file
  -j JSON_OUTPUT, --json-output JSON_OUTPUT
                        Json output file
  -o HTML_OUTPUT, --html-output HTML_OUTPUT
                        HTML output file
```

## Configuration File Documentation

This configuration file defines settings for a package tracking system that compares packages across different Debian distributions and architectures.

### `cache-dir`
**Type:** String  
**Default:** `/var/cache/derivative-dist-compare`  
**Description:** Defines a temporary location to fetch each distribution's apt repositories.

**Example:**
```yaml
cache-dir: /tmp/test
```

### `archs`
**Type:** List of strings  
**Default:** Current system architecture  
**Description:** Defines a list of Debian architectures to include in the comparison.

**Example:**
```yaml
archs:
  - amd64
  - arm64
```

### `distros`
**Type:** Object  
**Description:** Defines the list of distributions, either upstream distributions or derivatives.

Each distribution entry can have the following properties:

- **`sources.list`** or **`sources`**: Repository configuration
  - Use `sources.list` for traditional apt format
  - Use `sources` for DEB822 format
- **`preferences`** *(optional)*: APT preferences for package pinning
- **`parent`** *(optional)*: For derivative distributions, specifies the parent distribution to compare against
- **`vendor-suffix`** *(optional)*: Adjusts version comparison for derivative distributions

#### Parent Distributions

```yaml
distros:
  sid:
    sources.list: |
      deb http://deb.debian.org/debian sid main contrib non-free non-free-firmware
      deb http://deb.debian.org/debian experimental main contrib non-free non-free-firmware
```

#### Derivative Distributions

```yaml
distros:
  trixie-fastforward-backports:
    parent: sid
    vendor-suffix: ffwd
    sources: |
      Types: deb
      URIs: https://deb.fastforward.debian.net/debian-fastforward
      Suites: trixie-fastforward-backports
      Components: main contrib non-free non-free-firmware
```

#### Using APT Preferences
APT preferences can be used to control package selection and pinning:

```yaml
distros:
  debian-experimental:
    sources.list: |
      deb http://deb.debian.org/debian experimental main contrib non-free non-free-firmware
    preferences: |
      Package: git:* git*:*
      Pin: version /next/
      Pin-Priority: -1
```

**Common preference examples:**
- **Pin by version pattern:** `Pin: version 54.0.*`
- **Pin by origin:** `Pin: origin "example.com"`
- **Pin by suite:** `Pin: release a=stable`
- **Pin priority values:**
  - `1000+`: Always install this version
  - `990`: Used for versions from the target release
  - `500`: Used for versions from normal archives
  - `100`: Used for installed packages
  - `-1`: Never install this version


### `package-sets`

**Type:** Object  
**Description:** Defines logical groupings of source packages for organizational purposes. When sorted, the HTML table will display packages organized by these sets.


- **Key:** Set name (used as identifier)
- **Value:** List of source packages to include in this set

## Configuration Example

```yaml
cache-dir: /tmp

archs:
  - amd64
  - arm64

distros:
  # Parent distributions
  sid:
    bugs-url: https://bugs.debian.org/cgi-bin/pkgreport.cgi?repeatmerged=no&src=
    tracker-url: https://tracker.debian.org/pkg/
    sources.list: |
      deb http://deb.debian.org/debian sid main contrib non-free non-free-firmware
      deb http://deb.debian.org/debian experimental main contrib non-free non-free-firmware
    # Optional apt pinning
    preferences: |
      Package: src:git:any
      Pin: version /next/
      Pin-Priority: -1

      Package: src:libreoffice:any
      Pin: version /rc1/
      Pin-Priority: -1

      Package: src:openvpn:any
      Pin: version /rc1/
      Pin-Priority: -1

  # Derivative distributions
  trixie-fastforward-backports:
    parent: sid
    vendor-suffix: ffwd
    sources: |
      Types: deb
      URIs: https://deb.fastforward.debian.net/debian-fastforward
      Suites: trixie-fastforward-backports
      Components: main contrib non-free non-free-firmware

package-sets:
  web:
    - bootstrap-html
    - bootstrap-icons
    - haproxy
  
  python:
    - jinjax
```

This configuration enables tracking and comparison of packages across different Debian distributions and architectures, with organized package sets for better management and display.

## Development Setup

To get started with the development of *Detrivative Dist Compare*, you need to create a Python virtual environment. This ensures that your development environment is isolated and you can easily manage dependencies.

1. **Create the virtual environment**:

   Run the following command to create a virtual environment:

   ```bash
   python3 -m venv .venv
   ```

   This command creates a virtual environment in the `.venv` directory while giving access to globally installed packages. This is required to utilize system-wide packages python3-apt.

2. **Activate the virtual environment**:

     ```bash
     source .venv/bin/activate
     ```

3. **Make `apt` and `apt_pkg` available in the virtual environment**:

   Since the `apt` and `apt_pkg` modules are part of the system-wide packages, you need to link them manually into your virtual environment:

   ```bash
   ln -s /usr/lib/python3/dist-packages/apt_pkg.cpython-311-x86_64-linux-gnu.so .venv/lib/python3.11/site-packages/
   ln -s /usr/lib/python3/dist-packages/apt .venv/lib/python3.11/site-packages/
   ```

   These commands create symbolic links to make `apt` and `apt_pkg` accessible in your virtual environment.

4. **Install project dependencies**:

   Once the virtual environment is active, install the necessary dependencies using `pip`:

   ```bash
   pip install -e .
   ```

   This will install all the required libraries and packages for the project.
